SYSTEM(Run = 1)
DLG(TI='interpolation, integration, and differentiation', Edit='#Describe', Button='OK')
DO
    SET($max=10, yi=0, xA=0, xZ=100, dX=1,  yA=-1, yZ=2)
    xymtx(10,2) = 0             ! define 10 rows/2 column xy matrix
    xymtx($,1) = RAN(50, 50)    ! x is set to a random number 50+-50
    xymtx($,2) = RAN(0, 100)    ! y is set to random +-100
    SORT(Column=1, Sort=xymtx)  ! a SORTED x is required

    checks($) = ('Interpolate y(x)', 'Integrate(0,x)', 'dy/dx', 'd2y/dx2')
    DLG(Button='OK', CHeckbox=checks, Value=CHECKED)

    DLG(TI='Akima-interpolation, -integration, -differentation1*+2*', Rs=2, Cs=2, AX=2,
        TI='Blue=interpolate, Red=Integrate/10, Cyan=dy/dx, Magenta broken=d2y/dx2*10',
        Y=0, MIN=-100, MAX=200)
    LINE(Ax=2, COL=1, XV=xymtx,   Col=2, YV=xymtx,   S='🔴', D=-1)

    IF(INDEX(CHECKED, 'Interpolate'))
        DO xi = xA, xZ, dX
            yi = IPOL(xi, xymtx) ! interpolation for xi
            LINE(Ax=2, OneWayX=1, X=xi,Y=yi,W=3,D=9)
        ENDDO
    ENDIF

    IF(INDEX(CHECKED, 'Integrate'))
        DO xi = xA, xZ, dX
            yi = IPOL(xA, xymtx, xi) ! integral from start to xi
            yi = yi / 10
            LINE(Ax=2, OneWayX=1, X=xi,Y=yi,W=3,D=900)
        ENDDO
    ENDIF

    IF(INDEX(CHECKED, 'dy/dx'))
        DO xi = xA, xZ, dX
            yi = IPOL(xi, xymtx, xi - 1) ! dy/dx at position xi
            yi = yi
            LINE(Ax=2, OneWayX=1, X=xi,Y=yi,W=3,D=99)
        ENDDO
    ENDIF

    IF(INDEX(CHECKED, 'd2y/dx2'))
        DO xi = xA, xZ
            yi = IPOL(xi, xymtx, xi - 2) ! d2y/dx2 at position xi
            yi = yi * 10
            LINE(Ax=2, OneWayX=1, X=xi,Y=yi,W=3,Brok=1.2, D=909)
        ENDDO
    ENDIF
ENDDO
END

#Describe
. The Akima-algorithm is used for numerical
. interpolation, integration, and differentiation

Call:
.	result = IPOL(xi, xyMTX [, parm3])
with:
.	xi	interpolation x-value, no parm3
.		integration:	parm3 = upper limit, xi = lower limit
.		dy/dx:		parm3 = xi - 1
.		d2y/dx2:	parm3 = xi - 2
.	xyMTX	matrix:
.			column 1 = x values
.			column 2 = y values
.
#
